<?php
/**
* @file
* @brief    metaudio audio and music library
* @author   Levente Hunyadi
* @version  0.8.2
* @remarks  Copyright (C) 2010 Levente Hunyadi
* @remarks  Licensed under GNU/GPLv3, see http://www.gnu.org/licenses/gpl-3.0.html
* @see      http://hunyadi.info.hu/projects/metaudio
*/

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport('joomla.application.component.controller');

/**
* metaudio component recording controller
*/
class metaudioControllerRecording extends JControllerLegacy {
	public function __construct() {
		 parent::__construct();
		 // register extra tasks
		 $this->registerTask('edit', 'display');
	}

	/**
	* Authorizes access to the audio management interface.
	*/
	private function authorizeUser() {
		$user = JFactory::getUser();
		if ($user->guest) {  // only logged-in users are allowed to make edits
			$app = JFactory::getApplication();
			$app->enqueueMessage(JText::_('METAUDIO_ERROR_LOGIN_REQUIRED'), 'error');
			return false;
		} elseif (!$user->authorise('core.edit', 'com_metaudio')) {
			$app = JFactory::getApplication();
			$app->enqueueMessage(JText::_('METAUDIO_ERROR_PERMISSION_REQUIRED'), 'error');
			return false;
		} else {
			return true;
		}
	}

	/**
	* Displays the view.
	*/
	public function display($cachable = false, $urlparams = array()) {
		$jinput = JFactory::getApplication()->input;
		$layout = $jinput->get('layout', null);

		if (!isset($layout)) {
			$uri = \Joomla\CMS\Uri\Uri::getInstance();
			$uri->setVar('option', 'com_metaudio');
			$uri->setVar('view', 'recording');
			switch ($this->getTask()) {
				case 'edit':
					if ($this->authorizeUser()) {
						$uri->setVar('layout', 'edit');
					} else {
						$uri->setVar('layout', 'default');
					}
					break;
				default:
					$uri->setVar('layout', 'default');
			}
			$this->setRedirect(JRoute::_($uri->toString(), false));
		}

		parent::display($cachable, $urlparams);
	}

	private function store() {
		$jinput = JFactory::getApplication()->input;
		$path = $jinput->getPath('f');
		if (isset($path)) {
			$newpath = $jinput->getPath('filename', $path);
			$metadata = $jinput->getRaw('meta', array());

			// process uploaded files
			foreach ($_FILES as $postname => $postdata) {
				list($prefix, $key) = explode('-', $postname, 2);
				if ($prefix == 'meta' && $postdata['size'] > 0) {
					$metadata[$key] = array(
						'mime' => $postdata['type'],
						'file' => $postdata['tmp_name']
					);
				}
			}

			$model = $this->getModel('recording');
			$model->updateRecording($path, $newpath, $metadata);
		}
	}

	public function save() {
		if ($this->authorizeUser()) {  // check user permissions
			$this->store();
		}

		$menu = JFactory::getApplication()->getMenu();
		$activemenu = $menu->getActive();
		if ($activemenu) {
			$menuid = $activemenu->id;
		}
		$this->setRedirect(JRoute::_('index.php?option=com_metaudio&Itemid='.$menuid, false));
	}

	public function apply() {
		if ($this->authorizeUser()) {  // check user permissions
			$this->store();

			$uri = \Joomla\CMS\Uri\Uri::getInstance();
			$uri->setVar('option', 'com_metaudio');
			$uri->setVar('view', 'recording');
			$uri->setVar('layout', 'edit');
			$this->setRedirect(JRoute::_($uri->toString(), false));
		}

		parent::display();
	}

	public function cancel() {
		$menu = JFactory::getApplication()->getMenu();
		$activemenu = $menu->getActive();
		if ($activemenu) {
			$menuid = $activemenu->id;
		}
		$this->setRedirect(JRoute::_('index.php?option=com_metaudio&Itemid='.$menuid, false));
	}
}