<?php
/**
* @file
* @brief    metaudio audio and music library
* @author   Levente Hunyadi
* @version  0.8.2
* @remarks  Copyright (C) 2010 Levente Hunyadi
* @remarks  Licensed under GNU/GPLv3, see http://www.gnu.org/licenses/gpl-3.0.html
* @see      http://hunyadi.info.hu/projects/metaudio
*/

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

// require the base controller
require_once JPATH_COMPONENT.DIRECTORY_SEPARATOR.'controller.php';

$jinput = JFactory::getApplication()->input;

// require specific controller if requested
if ($controller = $jinput->getWord('controller')) {
    $path = JPATH_COMPONENT.DIRECTORY_SEPARATOR.'controllers'.DIRECTORY_SEPARATOR.$controller.'.php';
    if (file_exists($path)) {
        require_once $path;
    } else {
        $controller = '';
    }
}

// create the controller
$classname = 'metaudioController'.$controller;
$controller = new $classname( );

// perform the request task
$controller->execute($jinput->getWord('task'));

// Redirect if set by the controller
$controller->redirect();
